#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/thi/header.h"
#include "levels/hmc/header.h"

extern u8 _thi_segment_ESegmentRomStart[];
extern u8 _thi_segment_ESegmentRomEnd[];

const LevelScript level_thi_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _hmc_segment_7SegmentRomStart, _hmc_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _hmcSegmentRomStart, _hmcSegmentRomEnd),
LOAD_RAW(0x0E, _thi_segment_ESegmentRomStart, _thi_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _water_skybox_mio0SegmentRomStart, _water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group11_mio0SegmentRomStart, _group11_mio0SegmentRomEnd),
LOAD_RAW(12, _group11_geoSegmentRomStart, _group11_geoSegmentRomEnd),
LOAD_MIO0(6, _group14_mio0SegmentRomStart, _group14_mio0SegmentRomEnd),
LOAD_RAW(13, _group14_geoSegmentRomStart, _group14_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_HMC_WOODEN_DOOR,          wooden_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_HMC_METAL_DOOR,           metal_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_HMC_HAZY_MAZE_DOOR,       hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_HMC_METAL_PLATFORM,       hmc_geo_0005A0),
LOAD_MODEL_FROM_GEO(MODEL_HMC_METAL_ARROW_PLATFORM, hmc_geo_0005B8),
LOAD_MODEL_FROM_GEO(MODEL_HMC_ELEVATOR_PLATFORM,    hmc_geo_0005D0),
LOAD_MODEL_FROM_GEO(MODEL_HMC_ROLLING_ROCK,         hmc_geo_000548),
LOAD_MODEL_FROM_GEO(MODEL_HMC_ROCK_PIECE,           hmc_geo_000570),
LOAD_MODEL_FROM_GEO(MODEL_HMC_ROCK_SMALL_PIECE,     hmc_geo_000588),
LOAD_MODEL_FROM_GEO(MODEL_HMC_RED_GRILLS,           hmc_geo_000530),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(29,  wooden_door_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_GEO(88, 0x0500c778),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_12),
JUMP_LINK(script_func_global_15),
JUMP_LINK(local_area_thi_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_thi_1_[] = {
AREA(1, Geo_thi_1_0x178c180),
TERRAIN(col_thi_1_0xe03a7c0),
SET_BACKGROUND_MUSIC(0, 49),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_thi_1_),
JUMP_LINK(local_warps_thi_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_thi_1_[] = {
OBJECT_WITH_ACTS(0, 4750, -2476, 4750, 0, 225, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(0, 0, 540, 3775, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(0, 375, 750, 3043, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(0, 1092, 1017, 3177, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(0, 1550, 1451, 3044, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(0, 2276, 1752, 2491, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(0, 2885, 2192, 2716, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(0, 3131, 2874, 1705, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(0, 414, 4346, 2511, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(0, 790, 5218, 3353, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(0, 1516, 5706, 2462, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(0, 1304, 3858, 2414, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(32, -2229, -3500, -1778, 0, 247, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(87, -5172, -889, 0, 0, 0, 0, 0x0,  bhvWigglerHead, 31),
OBJECT_WITH_ACTS(122, 0, 6750, 0, 0, 0, 0, 0x1000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 300, 4011, -2935, 0, 0, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 6889, -1200, -6918, 0, 0, 0, 0x5000000,  bhvStar, 31),
OBJECT_WITH_ACTS(0, 859, -5269, -570, 0, 0, 0, 0x3000000,  bhvHiddenStar, 31),
OBJECT_WITH_ACTS(122, 2197, -5425, -3719, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(122, 3785, -5225, -2672, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(122, 5766, -5425, -2563, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(122, 6122, -5425, 1719, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(122, 5242, -5425, -112, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(121, 6077, -5475, -1506, 0, 247, 180, 0x0,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(121, 6826, -5475, 31, 0, 337, 180, 0x0,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(0, 3785, -6500, -2672, 0, 0, 0, 0x40000,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(121, 2448, -5475, -2991, 0, 319, 180, 0x0,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(180, 7247, -5475, -1646, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 2696, -5475, -1806, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 3384, -5475, 562, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(0, 2860, -5525, -615, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(121, 4758, -5475, 1107, 0, 157, 180, 0x0,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(0, -4573, -2844, -4877, 0, 0, 0, 0x4000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(215, -770, -1200, 5889, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 81, -3450, -3219, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -5163, -1500, 1078, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -5388, -339, 5554, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -5130, -3450, -5512, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 2394, -3450, 2370, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -3337, -3450, 2957, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -3341, -2950, -1840, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(0, -4278, -3500, 4773, 0, 0, 0, 0x10000,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(100, 3819, -3500, 3786, 0, 0, 0, 0x0,  bhvPiranhaPlant, 31),
OBJECT_WITH_ACTS(100, -4047, -3500, 2355, 0, 0, 0, 0x0,  bhvPiranhaPlant, 31),
OBJECT_WITH_ACTS(100, -1085, -3500, -6046, 0, 0, 0, 0x0,  bhvPiranhaPlant, 31),
OBJECT_WITH_ACTS(0, -3194, -3500, -5615, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(84, 2680, 1800, -2771, 0, 0, 0, 0x0,  bhvEnemyLakitu, 31),
OBJECT_WITH_ACTS(84, -5404, 1081, 5563, 0, 0, 0, 0x0,  bhvEnemyLakitu, 31),
OBJECT_WITH_ACTS(24, -3501, -3500, 4441, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(24, -5572, -3500, 2285, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(24, -5188, -3500, -3788, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(24, -868, -3500, -5284, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(24, -3346, -3500, -1837, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(24, 3455, -3500, -624, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(24, -59, -3500, 3852, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(24, 5062, -3500, 3250, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(24, -5647, -3500, 4322, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(212, -1102, -3450, -3514, 0, 190, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(0, 4040, -200, -531, 0, 14, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 663, -2600, 5897, 0, 14, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -851, -2600, 5897, 0, 14, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -88, -1200, 5897, 0, 14, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -65, 736, 4772, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -5163, -2500, 1078, 0, 14, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -4573, -3100, -4877, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -3003, -3500, -5488, 0, 98, 0, 0x40000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 4969, -3500, -352, 0, 221, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(192, 5470, -3500, 822, 0, 0, 0, 0x10000,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, 2570, -3500, 6149, 0, 0, 0, 0x10000,  bhvGoomba, 31),
OBJECT_WITH_ACTS(180, 5766, -5425, -2563, 0, 0, 0, 0x40000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(116, 2366, -2650, 3642, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, 2704, -1850, 2667, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, 699, 2111, -2923, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, 516, 2936, -3273, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(0, 1966, 3719, 1964, 0, 14, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -3235, 239, 5323, 0, 270, 0, 0x100000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -5172, 239, 3568, 0, 180, 0, 0x100000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(137, 6751, -2375, -6789, 0, 0, 0, 0x10000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 3332, 1175, -1693, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(0, 1977, 1336, -3341, 0, 0, 0, 0x7e0000,  bhvPoleGrabbing, 31),
OBJECT_WITH_ACTS(0, 857, -5525, -576, 0, 0, 0, 0x0,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(0, 857, -5525, -576, 0, 0, 0, 0x1000000,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(0, -2780, -3000, -2026, 0, 245, 0, 0x10000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(124, -1655, -389, 4999, 0, 0, 0, 0x450000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(124, 2883, -3500, 3288, 0, 72, 0, 0x460000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(120, 2564, -3400, 3130, 0, 6, 0, 0x460000,  bhvRecoveryHeart, 31),
OBJECT_WITH_ACTS(124, -294, 736, 4220, 0, 32, 0, 0x470000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(124, -2730, -3500, -5991, 0, 291, 0, 0x480000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(0, 8, 5, 270, 0, 0, 20, 5,  RM_Scroll_Texture, 31),
OBJECT_WITH_ACTS(0, 8, 5, 4, 0, 0, 20, 6,  RM_Scroll_Texture, 31),
OBJECT_WITH_ACTS(0, 8, 5, 20, 0, 0, 20, 7,  RM_Scroll_Texture, 31),
RETURN()
};

const LevelScript local_warps_thi_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(0, 13, 1, 1, 0),
WARP_NODE(1, 13, 1, 0, 0),
WARP_NODE(240, 6, 3, 43, 0),
WARP_NODE(241, 6, 3, 53, 0),
RETURN()
};
